.intel_syntax noprefix

.data

.text

    .global perfect_power

# unsigned perfect_power(unsigned n, unsigned *m, unsigned *k)
#      eax                      edi          rsi          rdx

perfect_power:
    enter 0, 0
    
    cmp edi, 1
    je special_case
    
    mov r11d, edi
    shr r11d, 1
    
    mov ecx, 2
    
outer_loop:
    cmp ecx, r11d
    ja end_outer_loop
    
    mov r15d, ecx
    mov ebx, 1

inner_loop:
    cmp r15d, edi
    ja end_inner_loop
    
    cmp r15d, edi
    jne skip
    
    mov [rsi], ecx
    mov [rdx], ebx
    mov eax, 1
    jmp end
    
skip:
    push rdx
    push rax

    mov eax, r15d
    mul ecx
    mov r15d, eax
    
    pop rax
    pop rdx

    inc ebx
    jmp inner_loop

end_inner_loop:

    inc ecx
    jmp outer_loop

end_outer_loop:
    mov eax, 0
    jmp end

special_case:
    mov [rsi], dword ptr 1
    mov [rdx], dword ptr 2
    mov eax, 1
    jmp end

end:    
    leave
    ret

